
#define _SUPPRESS_PLIB_WARNING
#define _DISABLE_OPENADC10_CONFIGPORT_WARNING
#include <plib.h>
#include "buttons.h"

static unsigned short S1down, S2down;
static unsigned char last_button_state, buttons_down;
unsigned char lbutton_short_press, lbutton_long_press, rbutton_short_press, rbutton_long_press, bbutton_short_press, bbutton_long_press, bbutton_shortlong_press_lr, bbutton_shortlong_press_rl;

__attribute__((mips16)) void buttons_init() {
  TRISB |= (1<<5)|(1<<6);
  CNPUB |= (1<<5)|(1<<6);
  TMR2 = 0;
  TMR3 = 0;
  T2CONbits.T32 = 1;
  TMR2 = 0;
  PR2 = 0xFFFFFFFF;
  T2CONbits.TON = 1;
}

__attribute__((mips16)) void buttons_teardown() {
  TRISB &= ~((1<<5)|(1<<6));
  CNPUB &= ~((1<<5)|(1<<6));
  T2CON = 0;
  T3CON = 0;
}

__attribute__((mips16)) void buttons_handle_presses() {
#ifndef __DEBUG
    if( !PORTBbits.RB5 && !(last_button_state&1) ) {
        S1down = TMR3;
        last_button_state |= 1;
        buttons_down |= 1;
    } else if( PORTBbits.RB5 && (last_button_state&1) ) {
        last_button_state &= ~1;
        if( last_button_state == 0 ) {
            if( ((TMR3 - S1down)&65535) > BUTTON_DEBOUNCE_TIME ) {
                unsigned short time_down = TMR3;
                time_down -= S1down;
                if( buttons_down&2 ) {
                    unsigned short other_time_down = TMR3;
                    other_time_down -= S2down;
                    if( time_down > LONG_BUTTON_TIME && other_time_down > LONG_BUTTON_TIME )
                        ++bbutton_long_press;
                    else if( other_time_down > BUTTON_DEBOUNCE_TIME )
                        ++bbutton_shortlong_press_rl;
                    else
                        ++bbutton_short_press;
                } else {
                    if( time_down > LONG_BUTTON_TIME )
                        ++rbutton_long_press;
                    else
                        ++rbutton_short_press;
                }
            }
            buttons_down = 0;
        }
    }
    if( !PORTBbits.RB6 && !(last_button_state&2) ) {
        S2down = TMR3;
        last_button_state |= 2;
        buttons_down |= 2;
    } else if( PORTBbits.RB6 && (last_button_state&2) ) {
        last_button_state &= ~2;
        if( last_button_state == 0 ) {
            if( ((TMR3 - S2down)&65535) > BUTTON_DEBOUNCE_TIME ) {
                unsigned short time_down = TMR3;
                time_down -= S2down;
                if( buttons_down&1 ) {
                    unsigned short other_time_down = TMR3;
                    other_time_down -= S1down;
                    if( time_down > LONG_BUTTON_TIME && other_time_down > LONG_BUTTON_TIME )
                        ++bbutton_long_press;
                    else if( other_time_down > BUTTON_DEBOUNCE_TIME )
                        ++bbutton_shortlong_press_lr;
                    else
                        ++bbutton_short_press;
                } else {
                    if( time_down > LONG_BUTTON_TIME )
                        ++lbutton_long_press;
                    else
                        ++lbutton_short_press;
                }
            }
            buttons_down = 0;
        }
    }
#endif
}
